@extends('layouts.layoutapp')

@section('content')

    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Edit Invoice EMI</h5>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <form action="{{ route('invoice-emi-update') }}" method="POST" id="invoiceForm">
                            @csrf
                           <input type="hidden" name="id" value="{{$invoice->id}}">
                            <div class="row">
                                <div class="col-lg-3 mb-3">
                                    <label for="client_name" class="form-label">Client Name:</label>
                                    <input type="text" name="client_name" id="client_name" class="form-control" 
                                           value="{{ old('client_name', $invoice->client->user->name) }}" readonly>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="client_num" class="form-label">Client Number:</label>
                                    <input type="text" name="client_num" id="client_num" class="form-control" 
                                           value="{{ old('client_num', $invoice->client->user->phone) }}" readonly>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="invoice_id" class="form-label">Invoice number:</label>
                                    <input type="text" id="invoice_id" class="form-control" value="{{ $invoice->invoice_id }}" readonly>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="invoice_date" class="form-label">Invoice Date:</label>
                                    <input type="date" id="invoice_date" class="form-control" disabled name="invoice_date" 
                                           value="{{ old('invoice_date', $invoice->invoice_date) }}" required>
                                    @error('invoice_date')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="due_date" class="form-label">Due Date:</label>
                                    <input type="date" id="due_date" class="form-control" disabled name="due_date" 
                                           value="{{ old('due_date', $invoice->due_date) }}" required>
                                    @error('due_date')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="gst" class="form-label">GST/Non-GST:</label>
                                    <select name="gst" id="gst" class="form-select" onchange="toggleTaxes()" disabled>
                                        <option value="">Select</option>
                                        <option value="Y" {{ old('gst', $invoice->gst) == 'Y' ? 'selected' : '' }}>GST</option>
                                        <option value="N" {{ old('gst', $invoice->gst) == 'N' ? 'selected' : '' }}>Non-GST</option>
                                    </select>
                                    @error('gst')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <hr>
                            <div>
                                <h5>Product Details:</h5>
                                <div class="row align-items-center">
                                    <div class="col-lg-4 d-flex align-items-center mb-3">
                                        <i class="fa-solid fa-qrcode" style="width: 30px; height: 30px; margin-right: 10px;"></i>
                                        <input class="form-control" type="text" id="product-code-input" onkeydown="preventFormSubmit(event)" disabled>
                                    </div>
                                    <div class="col-lg-4">
                                        <button type="button" onclick="addRow(event)" disabled class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Row
                                        </button>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="productsTable">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>#</th>
                                                <th>Product</th>
                                                <th>Avl. Qty</th>
                                                <th>Qty</th>
                                                <th>Unit Price</th>
                                                <th>Tax</th>
                                                <th>Amount</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="productRows">
                                            @foreach($invoice->invoiceItems as $index => $item)
                                                                                        @php
                                                                                            $product = $products->firstWhere('id', $item->product_id);
                                                                                            $currentQty = $product ? $product->qty + $item->quantity : 0;
                                                                                            $taxIds = $item->invoiceItemTaxes->pluck('tax_id')->toArray();
                                                                                        @endphp
                                                                                        <tr id="row-{{ $index }}">
                                                                                            <td>{{ $index + 1 }}</td>
                                                                                            <td>
                                                                                                <select name="dynamicFields[{{ $index }}][product]" class="form-select product-select" 
                                                                                                        onchange="updateProductDetails({{ $index }})" disabled>
                                                                                                    <option value="">Select Product</option>
                                                                                                    @foreach($products as $product)
                                                                                                        <option value="{{ $product->id }}" 
                                                                                                                {{ $item->product_id == $product->id ? 'selected' : '' }}>
                                                                                                            {{ $product->code }}-{{ $product->name }}
                                                                                                        </option>
                                                                                                    @endforeach
                                                                                                </select>
                                                                                            </td>
                                                                                            <td style="width:120px;">
                                                                                                <input type="text" name="dynamicFields[{{ $index }}][avl_qty]" 
                                                                                                       class="form-control avl-qty" value="{{ $currentQty }}" readonly />
                                                                                            </td>
                                                                                            <td style="width:120px;">
                                                                                                <input type="text" name="dynamicFields[{{ $index }}][qty]" 
                                                                                                       class="form-control qty" value="{{ $item->quantity }}" 
                                                                                                       onchange="calculateRowAmount({{ $index }})" disabled/>
                                                                                            </td>
                                                                                            <td style="width:120px;">
                                                                                                <input type="text" name="dynamicFields[{{ $index }}][unit_price]" 
                                                                                                       class="form-control unit-price" value="{{ $item->price }}" 
                                                                                                       onchange="calculateRowAmount({{ $index }})"disabled />
                                                                                            </td>
                                                                                            <td style="min-width: 200px;">
                                                                                                @if($invoice->gst == 'N')
                                                                                                    <input type="text" class="form-control" value="No Taxes Applied" readonly>
                                                                                                @else
                                                                                                    <select name="dynamicFields[{{ $index }}][tax][]" class="form-select tax-select" multiple
                                                                                                            style="height: auto; min-height: 38px;"
                                                                                                            onchange="calculateRowAmount({{ $index }})" disabled>
                                                                                                        @foreach($all_taxes as $tax)
                                                                                                            <option value="{{ $tax->id }}" 
                                                                                                                    {{ in_array($tax->id, $taxIds) ? 'selected' : '' }}
                                                                                                                    data-rate="{{ $tax->value }}">
                                                                                                                {{ $tax->name }} - {{ $tax->value }}%
                                                                                                            </option>
                                                                                                        @endforeach
                                                                                                    </select>
                                                                                                @endif
                                                                                            </td>
                                                                                            <td style="width:120px;">
                                                                                                <input type="text" name="dynamicFields[{{ $index }}][amount]" 
                                                                                                       class="form-control amount" value="{{ $item->total }}" readonly />
                                                                                            </td>
                                                                                            
                                                                                            <td class="text-center align-middle" style="max-width: 50px;">
    <a href="javascript:void(0);" onclick="removeRow({{ $index }})" class="text-danger fs-5" title="Remove Row">
        <i class="fas fa-trash"></i>
    </a>
</td>
                                                                                        </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row mt-5">
                                <div class="col-lg-6 mb-3 d-flex">
                                    <div class="col-lg-6">
                                        <label for="discount_type" class="form-label">Discount type:</label>
                                        <select name="discount_type" id="discount_type" class="form-select" onchange="calculateTotal()" disabled>
                                            <option value="">Select discount type</option>
                                            @foreach($discount_types as $type)
                                                <option value="{{ $type->id }}" 
                                                        {{ old('discount_type', $invoice->discount_type) == $type->id ? 'selected' : '' }}>
                                                    {{ $type->type }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('discount_type')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-6">
                                        <label for="discount" class="form-label">Discount:</label>
                                        <input type="number" id="discount" name="discount" class="form-control" 
                                               value="{{ old('discount', $invoice->discount) }}" onchange="calculateTotal()" 
                                               {{ empty(old('discount_type', $invoice->discount_type)) ? 'readonly' : '' }}>
                                        @error('discount')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-5 mb-3">
                                    <div class="card shadow-lg">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Sub Total:</span>
                                                <span id="subTotalDisplay">{{ number_format($invoice->amount, 2) }} ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Discount:</span>
                                                <span id="discountDisplay">{{ number_format($invoice->discount, 2) }} ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Tax:</span>
                                                <span id="taxDisplay">{{ number_format($invoice->final_amount - $invoice->amount + $invoice->discount, 2) }} ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Total:</span>
                                                <span id="totalDisplay">{{ number_format($invoice->final_amount, 2) }} ₹</span>
                                            </div>
                                            <input type="hidden" id="sub_total" name="sub_total" value="{{ $invoice->amount }}">
                                            <input type="hidden" id="discount_amt" name="discount_amt" value="{{ $invoice->discount }}">
                                            <input type="hidden" id="tax" name="tax" 
                                                   value="{{ $invoice->final_amount - $invoice->amount + $invoice->discount }}">
                                            <input type="hidden" id="total_amt" name="total_amt" value="{{ $invoice->final_amount }}">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- <hr>
                            <div>
                                <button type="button" onclick="toggleNotesAndTerms()" class="btn btn-primary" id="notesTermsBtn">
                                    @if($invoice->note || $invoice->term)
                                        <i class="fas fa-minus"></i> remove Note & Term
                                    @else
                                        <i class="fas fa-plus"></i> Add Note & Term
                                    @endif
                                </button>                            
                            </div> --}}
                            <div class="modal-footer">
                                {{-- <button type="submit" class="btn btn-primary">Update</button> --}}
                                <a href="{{ route('invoice-emi-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Product data from backend
        const products = @json($products);
        const taxes = @json($all_taxes);
        const defaultTaxIds = @json($default_taxes);        
        let rowCount = {{ count($invoice->invoiceItems) }};

        function preventFormSubmit(event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                addProductRow();
                setTimeout(() => {
                    document.getElementById('product-code-input').focus();
                }, 1000);
            }
        }

        function addRow(event) {
            event.preventDefault();
            addProductRow();
            setTimeout(() => {
                document.getElementById('product-code-input').focus();
            }, 1000);
        }

        function addProductRow() {
            const productCode = document.getElementById('product-code-input').value;
            if (!productCode) {
                addEmptyRow();
                return;
            }

            const product = products.find(p => p.code === productCode);
            if (product) {
                addProductToTable(product);
                document.getElementById('product-code-input').value = '';
            } else {
                alert('Product not found!');
            }
        }

        function addEmptyRow() {
            rowCount++;
            const row = `
                <tr id="row-${rowCount}">
                    <td>${rowCount}</td>
                    <td>
                        <select name="dynamicFields[${rowCount}][product]" class="form-select product-select" 
                                onchange="updateProductDetails(${rowCount})">
                            <option value="">Select Product</option>
                            ${products.map(p => `<option value="${p.id}">${p.code}-${p.name}</option>`).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][avl_qty]" class="form-control avl-qty" readonly />
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][qty]" class="form-control qty" 
                               onchange="calculateRowAmount(${rowCount})" />
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][unit_price]" class="form-control unit-price" 
                               onchange="calculateRowAmount(${rowCount})" />
                    </td>
                    <td style="min-width: 200px;">
                        <select name="dynamicFields[${rowCount}][tax][]" class="form-select tax-select" multiple
                                style="height: auto; min-height: 38px;"
                                onchange="calculateRowAmount(${rowCount})">
                            ${taxes.map(t => {
                                const isDefault = defaultTaxIds.includes(t.id);
                                return `<option value="${t.id}" ${isDefault ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
                            }).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][amount]" class="form-control amount" readonly />
                    </td>
                    <td class="text-center align-middle" style="max-width: 50px;">
    <a href="javascript:void(0);" onclick="removeRow(${rowCount})" class="text-danger fs-5" title="Remove Row">
        <i class="fas fa-trash"></i>
    </a>
</td>
                </tr>
            `;
            document.getElementById('productRows').insertAdjacentHTML('beforeend', row);

            // If GST is selected, enable taxes, otherwise disable
            const gstValue = document.getElementById('gst').value;
            if (gstValue === 'N') {
                const taxSelect = document.querySelector(`#row-${rowCount} .tax-select`);
                Array.from(taxSelect.options).forEach(option => option.selected = false);
                taxSelect.disabled = true;
            }
        }

        function addProductToTable(product) {
            rowCount++;
            const row = `
                <tr id="row-${rowCount}">
                    <td>${rowCount}</td>
                    <td>
                        <select name="dynamicFields[${rowCount}][product]" class="form-select product-select" 
                                onchange="updateProductDetails(${rowCount})">
                            <option value="">Select Product</option>
                            ${products.map(p => `<option value="${p.id}" ${p.id == product.id ? 'selected' : ''}>${p.code}-${p.name}</option>`).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][avl_qty]" class="form-control avl-qty" 
                               value="${product.qty}" readonly />
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][qty]" class="form-control qty" 
                               value="1" onchange="calculateRowAmount(${rowCount})" />
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][unit_price]" class="form-control unit-price" 
                               value="${product.unit_price}" onchange="calculateRowAmount(${rowCount})" />
                    </td>
                    <td style="min-width: 200px;">
                        <select name="dynamicFields[${rowCount}][tax][]" class="form-select tax-select" multiple
                                style="height: auto; min-height: 38px;"
                                onchange="calculateRowAmount(${rowCount})">
                            ${taxes.map(t => {
                                const isDefault = defaultTaxIds.includes(t.id);
                                const isProductTax = product.taxes ? product.taxes.includes(t.id) : false;
                                const shouldSelect = isDefault || isProductTax;
                                return `<option value="${t.id}" ${shouldSelect ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
                            }).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][amount]" class="form-control amount" 
                               value="${product.unit_price}" readonly />
                    </td>
                    <td class="text-center align-middle" style="max-width: 50px;">
    <a href="javascript:void(0);" onclick="removeRow(${rowCount})" class="text-danger fs-5" title="Remove Row">
        <i class="fas fa-trash"></i>
    </a>
</td>
                </tr>
            `;
            document.getElementById('productRows').insertAdjacentHTML('beforeend', row);

            calculateRowAmount(rowCount);

            // If GST is selected, enable taxes, otherwise disable
            const gstValue = document.getElementById('gst').value;
            if (gstValue === 'N') {
                const taxSelect = document.querySelector(`#row-${rowCount} .tax-select`);
                Array.from(taxSelect.options).forEach(option => option.selected = false);
                taxSelect.disabled = true;
                calculateRowAmount(rowCount);
            }
        }

        function updateProductDetails(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const productId = row.querySelector('.product-select').value;
            const product = products.find(p => p.id == productId);

            if (product) {
                row.querySelector('.avl-qty').value = product.qty;
                row.querySelector('.qty').value = 1;
                row.querySelector('.unit-price').value = product.unit_price;
                calculateRowAmount(rowId);
            }
        }

        function calculateRowAmount(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const qty = parseFloat(row.querySelector('.qty').value) || 0;
            const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
            const amount = qty * unitPrice;

            // Calculate tax
            const taxSelect = row.querySelector('.tax-select');
            const selectedTaxes = Array.from(taxSelect.selectedOptions).map(opt => parseInt(opt.value));
            let taxRate = 0;

            selectedTaxes.forEach(taxId => {
                const tax = taxes.find(t => t.id == taxId);
                if (tax) taxRate += tax.value;
            });

            const taxAmount = amount * (taxRate / 100);
            const totalWithTax = amount + taxAmount;

            row.querySelector('.amount').value = amount.toFixed(2);
            calculateTotal();
        }

        function calculateTotal() {
            let subTotal = 0;
            let totalTax = 0;

            document.querySelectorAll('#productRows tr').forEach(row => {
                const amount = parseFloat(row.querySelector('.amount').value) || 0;
                const qty = parseFloat(row.querySelector('.qty').value) || 0;
                const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
                const rowAmount = qty * unitPrice;

                subTotal += rowAmount;

                // Calculate tax for this row
                const taxSelect = row.querySelector('.tax-select');
                const selectedTaxes = Array.from(taxSelect.selectedOptions).map(opt => parseInt(opt.value));
                let taxRate = 0;

                selectedTaxes.forEach(taxId => {
                    const tax = taxes.find(t => t.id == taxId);
                    if (tax) taxRate += tax.value;
                });

                totalTax += rowAmount * (taxRate / 100);
            });

            // Calculate discount
            const discountType = document.getElementById('discount_type').value;
            const discountValue = parseFloat(document.getElementById('discount').value) || 0;
            let discountAmount = 0;

    var subtotalWithTax = subTotal + totalTax;

            if (discountType == 1) {
                discountAmount = discountValue;
            } else if (discountType == 2) {
                discountAmount = subtotalWithTax * (discountValue / 100);
            }

            const total = subtotalWithTax - discountAmount;

            // Update display
            document.getElementById('subTotalDisplay').textContent = subTotal.toFixed(2) + ' ₹';
            document.getElementById('discountDisplay').textContent = discountAmount.toFixed(2) + ' ₹';
            document.getElementById('taxDisplay').textContent = totalTax.toFixed(2) + ' ₹';
            document.getElementById('totalDisplay').textContent = total.toFixed(2) + ' ₹';

            // Update hidden fields
            document.getElementById('sub_total').value = subTotal.toFixed(2);
            document.getElementById('discount_amt').value = discountAmount.toFixed(2);
            document.getElementById('tax').value = totalTax.toFixed(2);
            document.getElementById('total_amt').value = total.toFixed(2);
        }

        function toggleTaxes() {
            const gstValue = document.getElementById('gst').value;
            const taxSelects = document.querySelectorAll('.tax-select');

            taxSelects.forEach(select => {
                if (gstValue === 'N') {
                    $(select).val(null).trigger('change');
                    select.disabled = true;
                } else {
                    select.disabled = false;

                    $(select).val(defaultTaxIds.map(String)).trigger('change');
                }
            });

            calculateTotal();
        }

        function toggleNotesAndTerms() {
            const section = document.getElementById('notesTermsSection');
            const btn = document.getElementById('notesTermsBtn');

            if (section.style.display === 'none') {
                section.style.display = 'flex';
                btn.innerHTML = '<i class="fas fa-minus"></i> remove Note & Term';
            } else {
                section.style.display = 'none';
                btn.innerHTML = '<i class="fas fa-plus"></i> Add Note & Term';
            }
        }

        function removeRow(rowId) {
            document.getElementById(`row-${rowId}`).remove();
            // Renumber remaining rows
            let index = 1;
            document.querySelectorAll('#productRows tr').forEach(row => {
                row.cells[0].textContent = index;
                index++;
            });
            calculateTotal();
        }

        // Initialize on page load
        $(document).ready(function() {       

            // Set today's date as default for invoice and due date if not set
            if (!document.getElementById('invoice_date').value) {
                document.getElementById('invoice_date').valueAsDate = new Date();
            }
            if (!document.getElementById('due_date').value) {
                document.getElementById('due_date').valueAsDate = new Date();
            }

            // Enable/disable discount based on discount type
            document.getElementById('discount_type').addEventListener('change', function() {
                document.getElementById('discount').readOnly = !this.value;
                calculateTotal();
            });

            // Calculate initial totals
            calculateTotal();
        });
    </script>
@endpush