<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use App\Models\Tenant;

class TenantServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // No need to register anything here
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Extract the subdomain from the URL
        $host = request()->getHost();
        $subdomain = explode('.', $host)[0];
        // $subdomain = 'billing';
        // Find the tenant based on the subdomain
        //$tenant = Tenant::where('domain', $subdomain)->first();

        if ($subdomain) {
            // Set the tenant database name
            // $tenantDatabaseName = $tenant->database_name;

            // Update the database configuration dynamically
            Config::set('database.connections.mysql.database', $subdomain);

            // Purge and reconnect to the database with the new configuration
            DB::purge('mysql');
            DB::reconnect('mysql');
        } else {
            abort(404, 'Tenant not found.');
        }
    }
}
